;*****************************************************************************************************************
;Source File Name:
;		icbmui.jss
;Author's Name:
;		Ben Key 
;Description:
;		JFW Script file for icbmui.ocm, the executable program for the the instant message 
;		componet of AOL instant messenger.
;Included Header Files:
;	hjconst.jsh
;		default HJ constants 
;	hjglobal.jsh
;		default HJ global variables
;	aim.jsh
;		Global header file for the entire AIM project.  Contains all constants and globals used
;		in the AIM project.
;	aim.jsm
;		Global message file for entire AIM project.
;*****************************************************************************************************************
;															MODIFICATION LOG
;															================
; 07/06/1999		Ben Key
;		File added to aim project.
; 07/08/1999		Ben Key
;	Completed support for all the controls in SayFocusedWindow And screen sensitive help
; 07/08/1999		Ben Key
;	First stage of support for Instant Message chat window.
; 09/23/1999		Ben Key
;		Made a minor improvement to the AutoClearMessageDisplayWidowWhenTextReachesTargetRegion
;		algorithm.  The test if (strTemp != "") is no longer used to make the decision about whether or
;		not to call ClearMessageDisplayWin ().  The test that is currently implemented is 
;		If (StringLength (strTemp) > 2).  This helps to eliminate any chances for errors and 
;		speeds the process up somewhat.  Also increased the delay in scheduling the function
;		ResetnSuppressEcho to 12 from 10 to attempt to eliminate all possibility of over speakking
;		while clearing the message display window.
;		Also made considerable speed improvements to the processing that takes place in 
;		KeyPressedEvent (...) that is used to clear the message display window at the beginning 
;		of a new message if ClearDisplayWindow is equal to ACBeginMessage.
;*****************************************************************************************************************

include "hjconst.jsh"			; default HJ constants 
include "hjglobal.jsh"		; default HJ global variables
Include "AIM.jsh"
Include "AIM.jsm"

; ***/ AutoStartEvent and AutoFinishEvent functions
Void Function AutoStartEvent ()
Let numTimes = 0
Let nOrigTypeSetting = GetDefaultJCFOption (OPT_TYPING_INTERRUPT)
Let nOrigScreenSetting = GetDefaultJCFOption (OPT_SCREEN_ECHO)
If (IsMessageEditWindow () == 1) then
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, 0)
EndIf
; Change the value assigned to ClearDisplayWindow in the following line to set the default 
; option for automatically clearing the Message Display Window that you would prefer.
; Then recompile the script set to make your change take effect.  To set the option to "Auto 
; clear message display window on beginning of new message" by default, set the value of 
; ClearDisplayWindow to ACBeginMessage.  To set the option to "Auto clear message display 
; window on enter" by default, set it equal to ACOnEnter.  To set the default value to "Auto 
; clear message display window when text reaches target region," set ClearDisplayWindow 
; equal to ACTargetRegion.  To set the Auto clear message display window off by default, no 
; changes need to be made.
If (IcbmuiFirstTime == 0) then
	Let ClearDisplayWindow = ACOff
	Let IcbmuiFirstTime = 1
EndIf
EndFunction

Void Function AutoFinishEvent ()
SetDefaultJcfOption (OPT_TYPING_INTERRUPT, nOrigTypeSetting)
SetDefaultJcfOption (OPT_SCREEN_ECHO, nOrigScreenSetting)
EndFunction


; ***/ Functions that obtain information about the AIM environment and perform actions on the 
; AIM environment
Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
If (FindGraphic (winHandle, buttonLabel, s_top, s_restricted)) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgToolNotFound, ot_control_name)
EndIf
RestoreCursor ()
EndFunction

String Function BuildAvailableButtonsList (string strExpected, int nNumMax, handle hToolBar)
Var Int nCount, String strAvailableButtonsList, String strCanidate, Int nLength
Let nCount = 1
Let strAvailableButtonsList = ""
While (nCount <= nNumMax)
	Let strCanidate = StringSegment (strExpected, "\007", nCount)
	If (FindGraphic (hToolBar, strCanidate, S_TOP, S_RESTRICTED)) then
		Let strAvailableButtonsList = strAvailableButtonsList + "\007" + strCanidate
	EndIf
	Delay (1)
	Let nCount = nCount + 1
EndWhile
Let nLength = StringLength (strAvailableButtonsList)
Let strAvailableButtonsList = StringRight (strAvailableButtonsList, nLength - 1)
Return strAvailableButtonsList
EndFunction

Handle Function GetIMToolbar ()
;	This function is used to get the window handle of the tool bar found on the away page of the 
; edit preferences dialog box.
Var Handle rWin, Handle hTarget, Handle hTemp, Int nCount
Let rWin = GetRealWindow (GetFocus ())
Let hTemp = FindDescendantWindow (rWin, cID_InviteToolBarParent)
If (hTemp) then
	Let hTarget = FindDescendantWindow (hTemp, cID_InviteToolbar)
EndIf
Return hTarget
EndFunction

Void Function ResetnSuppressEcho ()
Let nSuppressEcho = FALSE
EndFunction

Void Function ResetSavedScreenEcho ()
SetDefaultJcfOption (OPT_SCREEN_ECHO, savedVal)
EndFunction

Int Function IsMessageEditWindow ()
Var Handle rWin, String rWinTitle, Handle curWin, String curWinClass,
	Handle pWin, String pWinClass, Handle targetParent, Handle hTarget, 
	Handle PriorWin, String PriorWinClass
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let pWin = GetParent (curWin)
Let pWinClass = GetWindowClass (pWin)
Let targetParent = FindDescendantWindow (rWin, cID_MessageChatParent)
Let hTarget = GetFirstChild (targetParent)
Let PriorWin = GetPriorWindow (pWin)
Let PriorWinClass = GetWindowClass (PriorWin)
If (StringContains (rWinTitle, wnSegIMChat)
	&& curWinClass == wcAte32
	&& pWinClass == wcWndAte32Class) then
	If (IsWindowVisible (hTarget) == FALSE) then
		; Is the chat window in the Instant Message invitation window
		Return 2
	ElIf (IsWindowVisible (hTarget) == TRUE) then
		If (PriorWinClass != wcOscarPersistantCombo) then
		; Is the edit window in the Instant Message chat window
			Return 1
		Else
			; Is the message display window
			Return 3
		EndIf
	EndIf
Else
	Return 0
EndIf
EndFunction

HANDLE Function FindMessageDislpayWindow ()
Var Handle targetParent, Handle hTarget, String rWinTitle, Handle rWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnSegIMChat)) then
	Let targetParent = FindDescendantWindow (rWin, cID_MessageChatParent)
	Let hTarget = GetFirstChild (targetParent)
	If (IsWindowVisible (hTarget) == FALSE) then Return 0 EndIf
	Return hTarget
Else
	Return 0
EndIf
EndFunction

HANDLE Function FindMessageEditWindow ()
Var Handle targetParent, Handle hTarget, String rWinTitle, Handle rWin
Let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
If (StringContains (rWinTitle, wnSegIMChat)) then
	Let targetParent = FindDescendantWindow (rWin, cID_ChatEditParent)
	Let hTarget = GetFirstChild (targetParent)
	If (IsWindowVisible (hTarget) == FALSE) then 
		Return 0 
	Else
		Return hTarget
	EndIf
Else
	Return 0
EndIf
EndFunction

Void Function ClearMessageDisplayWin ()
Var Handle hDisplayWin, Handle hChatWin, Int nOrgX, Int nOrgY
If (IsMessageEditWindow () == 1) then
	TrapKeys (TRUE)
	Let nOrgX = GetCursorCol ()
	Let nOrgY = GetCursorRow ()
	Let savedVal = GetDefaultJCFOption (OPT_SCREEN_ECHO)
	SetDefaultJcfOption (OPT_SCREEN_ECHO, 0)
	Let hDisplayWin = FindMessageDislpayWindow ()
	Let hChatWin = FindMessageEditWindow ()
	SaveCursor ()
	JAWSCursor ()
	MoveToWindow (hDisplayWin)
	Delay (1)
	RightMouseButton ()
	RestoreCursor ()
	Delay (1)
	{w}
	delay (1)
	{enter}
	SaveCursor ()
	JAWSCursor ()
	MoveTo (nOrgX, nOrgY)
	RoutePcToJAWS ()
	RestoreCursor ()
	If (StringLength (GetLine ()) >= 1) Then
		{Control+End}
	EndIf
	ScheduleFunction ("ResetSavedScreenEcho", 10)
	TrapKeys (FALSE)
EndIf
EndFunction

Void Function ClearMessageDisplayWindowWhenTextReachesTarget ()
Var Int nDisplayHeight, Int nDisplayTop, Int nDisplayBottom, 
	Int nDisplayLeft, Int nXpos, Int nYpos, Handle hDisplay, 
	String strTemp, Int nYpos1, Int nYpos2
Let hDisplay = FindMessageDislpayWindow ()
Let nDisplayTop = GetWindowTop (hDisplay)
Let nDisplayBottom = GetWindowBottom (hDisplay)
Let nDisplayLeft = GetWindowLeft (hDisplay)
Let nDisplayHeight = nDisplayBottom - nDisplayTop
Let nXpos = nDisplayLeft + 15
Let nYpos = nDisplayBottom - (nDisplayHeight / 3)
Let nYpos1 = nYpos + (nDisplayHeight / 12)
Let nYpos2 = nYpos1 + (nDisplayHeight / 12) 
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos1)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
SaveCursor ()
;InvisibleCursor ()
JAWSCursor ()
MoveTo (nXpos, nYpos2)
Let strTemp = GetLine ()
RestoreCursor ()
If (StringLength (strTemp) > 2) then
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 12)
	Return
EndIf
EndFunction

; ***/  All other event functions and related functions
Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, int nTextColor, 
	int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
If (nSuppressEcho == TRUE) then 
	Return 
Else
	NewTextEvent (hwnd, buffer, nAttributes, nTextColor, nBackgroundColor, nEcho, 
		sFrameName)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
; NonHighlightedText  Function for speaking all newly written nonhighlighted
; text.
Var Handle rWin, String rWinClass, String theClass, Handle hTemp
Let rWin = GetRealWindow (GetFocus ())
Let rWinClass = GetWindowClass (rWin)
Let theClass = GetWindowClass (hwnd)
Let hTemp = GetParent (hwnd)
Let hTemp = GetPriorWindow (hTemp)
; No matter what, speak the alt tab window
If (theClass == wcAltTab 
	&& GetScreenEcho () >= 1) then
	Say (buffer, ot_buffer)
ElIf (rWinClass == wcIMReal 
	&& theClass == wcAte32
	&& GetWindowClass (hTemp) == wcOscarPersistantCombo) then	
	Say (buffer, ot_buffer)
	If (ClearDisplayWindow == 3
		&& IsMessageEditWindow () == 1) then
		ScheduleFunction ("ClearMessageDisplayWindowWhenTextReachesTarget", 5)
	EndIf
EndIf
EndFunction

Void Function SayHighLightedText (handle hwnd, string buffer)
Var String rWinTitle, String hwndClass
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
Let hwndClass = GetWindowClass (hwnd)
If (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectItemDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (IsSelectScriptDlg ()) then
	SayHighLightedText (hwnd, buffer)
ElIf (GlobalMenuMode != MENU_INACTIVE) then
	SayHighLightedText (hwnd, buffer)
ElIf (hwndClass == wcSysTabControl) then
	If (numTimes == 0) then
		Say (buffer, ot_buffer)
		Let numTimes = 1
	ElIf (numTimes != 0) then
		Return
	EndIf
Else
	SayHighLightedText (hwnd, buffer)
EndIf
EndFunction

Void Function SayFocusedWindow ()
Var Int nTest, Handle curWin, String curWinClass
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let nTest = IsMessageEditWindow ()
If (nTest == 1) then
	Say (wnIMChat + " " + msgEditBox, ot_message)
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		SayChunk ()
	EndIf
	Return
ElIf (nTest == 2) then
	Say (wnIMInvitation + " " + msgEditBox, ot_message)
	If (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		SayChunk ()
	EndIf
	Return
ElIf (nTest == 3) then
	Say (wnMessageDisplay, ot_message)
	SayWindow (curWin, READ_EVERYTHING)
	Return
ElIf (curWinClass == wcOscarButton) then
	Say (GetWindowName (GetCurrentWindow ()) + " " + msgButton, ot_message)
	Return
EndIf 
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
Var int origSetting
If (nSuppressEcho == TRUE) then Return EndIf
If (IsMessageEditWindow () == 1) then
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, 0)
Else
	SetDefaultJcfOption (OPT_TYPING_INTERRUPT, nOrigTypeSetting)
EndIf
FocusChangedEvent (FocusWindow, PrevWindow)
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int nIsScriptKey)
Var String prevKeyName, Handle ChatWin, String strTemp, Int nKeyNameLen
; Return without any further processing if the keystroke is assigned to a script.
If (nIsScriptKey) then
	Return
EndIf
; Return without any further processing if ClearDisplayWindow is not equal to ACBeginMessage (1)
If (ClearDisplayWindow != ACBeginMessage) then
	Return
EndIf
; Get the length of the key name.  This will be used to assist in deciding whether or not to call 
; ClearMessageDisplayWin ()
Let nKeyNameLen = StringLength (strKeyName)
; Do nothing if the PC Cursor is not the active cursor.
If (IsPCCursor ()) then
	;  Use the length of the key name to determine if the keystroke is used for typing or for navigation.
	;  Do nothing if the keystroke is not used for typing.
	If (nKeyNameLen == 1		;  Any letter, number, or symbol
		|| nKey == 57	; The Space Bar
		|| nKeyNameLen == 7) Then	; Shift + Any letter, number, or symbol
		; Obtain the window handle of the Message Edit Window and copy any text it contains to a 
		; string buffer
		Let ChatWin = FindMessageEditWindow ()
		Let strTemp = GetWindowText (ChatWin, FALSE)
		;  Return without any further processing if the Message Edit Window contains any text.
		If (StringLength (strTemp) >= 1) then 
			Return
		; Otherwise if the Message Edit Window is the active window and ClearDisplayWindow is
		; equal to ACBeginMessage, then clear the message display window.
		ElIf (IsMessageEditWindow () == 1 
			&& ClearDisplayWindow == ACBeginMessage) then
			Let nSuppressEcho = TRUE
			ClearMessageDisplayWin ()
			ScheduleFunction ("ResetnSuppressEcho", 12)
			Return
		EndIf
	EndIf
EndIf
EndFunction

; ***/  Scripts
Script  ScriptFileName()
ScriptAndAppNames(msgIMScriptFile) ;msgIMScriptFile = "AOL Instant messenger Instant Message Chat",
EndScript

Script ClearMessageDisplayWindow ()
Let savedVal = GetDefaultJCFOption (OPT_SCREEN_ECHO)
Let nSuppressEcho = TRUE
ClearMessageDisplayWin ()
ScheduleFunction ("ResetnSuppressEcho", 10)
ScheduleFunction ("ResetSavedScreenEcho", 10)
EndScript

Script ScreenSensitiveHelp ()
var handle WinHandle, int TheTypeCode, String TheClass,
	String rWinTitle, Handle rWin, String strTemp, Int nTest
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheClass = GetWindowClass (WinHandle)
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
let rWin = GetRealWindow (GetFocus ())
Let rWinTitle = GetWindowName (rWin)
Let nTest = IsMessageEditWindow ()
If (nTest == 1) then
;	schmsgTextInDisplay = "The text that you type as well as the text that the other participants 
;		type will appear in the message display window",
;	schmsgWhenTextAppears = "When text appears in the message display window the newly 
;		written text is spoken automatically",
;	schmsgWhenFull = "When the message display window is filled with text it begins to scroll 
;		and the entire window is rewritten",
;	schmsgThisCauses = "This causes JFW to read the entire window",
;	schmsgSeveralOptions = "Several options have been added to help prevent this from being 
;		a problem",
;	schmsgClearWinScript = "The first option is the is the ClearMessageDisplayWindowScript 
;		which can be used to clear the message display window on command",
;	schmsgClearWinCalledBy = "It is called by pressing ",
;	schmsgAutoOptions = "Several other options have been added to automatically clear the 
;		message display window",
;	schmsgToggledBy = "These options may be toggled by the JAWS verbosity dialog"
	Say (schmsgThisIsThe + " " + wnIMChat + " " + shcmsgEditBox, ot_help)
	Say (schmsgMessageChat, ot_help)
	Say (schmsgTextInDisplay, ot_help)
	Say (schmsgWhenTextAppears, ot_help)
	Say (schmsgWhenFull, ot_help)
	Say (schmsgSeveralOptions, ot_help)
	Say (schmsgClearWinScript, ot_help)
	Say (schmsgClearWinCalledBy, ot_help)
	Say (GetScriptKeyName ("ClearMessageDisplayWindow"), ot_help)
	Say (schmsgAutoOptions, ot_help)
	Say (schmsgToggledBy, ot_help)
	Say (schmsgAccessToolBar + " " + GetScriptKeyName ("SelectATool"), ot_help)
	Say (schmsgToolBar, ot_help)
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (nTest == 2) then
	Say (schmsgThisIsThe + " " + wnIMInvitation + " " + shcmsgEditBox, ot_help)
	Say (schmsgGreeting, ot_help)
	Say (schmsgAccessToolBar + " " + GetScriptKeyName ("SelectATool"), ot_help)
	Say (schmsgToolBar, ot_help)
	Say (kcmsg008, ot_help) ;"Use the left and right arrow keys to move through the entered text"
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIF (nTest == 3) then
	Say (schmsgThisIsThe + " " + wnMessageDisplay, ot_help)
	Say (schmsgMessageDisplay, ot_help)
	Say (kcmsg006, ot_help) ;"Use the Tab key to move to the next Control"
	Return
ElIf (TheClass == wcOscarButton) then
	let strTemp = GetWindowName (GetCurrentWindow ())
	Say (kcmsg001, ot_help) ;"This is the"
	Say (strTemp, ot_help)
	Say (kcmsg001a, ot_help) ;"button"
	Say (kcmsg002, ot_help) ;"Use enter to activate it"
	Say (kcmsg003, ot_help) ;" Use Tab to move to the next Control"
	Return
EndIf
PerformScript ScreenSensitiveHelp()
EndScript

Script SelectATool ()
Var handle winHandle, int nItem,	String strButtonList, String strSelectedTool, Int nTest
Let nTest = IsMessageEditWindow ()
If (nTest == 0) then
		Say (msgIMEditOnly, ot_message)
		Return
ElIf (nTest == 1 || nTest == 2) then
	let winHandle = GetIMToolbar ()
	if (!winHandle || !IsWindowVisible (winHandle)) then
		return
	EndIf
	Let strButtonList = BuildAvailableButtonsList (IMToolbarA + IMToolbarB, 9, winHandle)
	let nItem = dlgSelectItemInList (strButtonList, IMToolbarDialogName, FALSE)
	If (nItem !=0) then
		Let strSelectedTool = StringSegment (strButtonList, "\007", nItem)
		let nSuppressEcho = TRUE
		delay (2)
		ClickToolBarButton (winHandle, strSelectedTool)
	EndIf
	ScheduleFunction ("ResetnSuppressEcho", 2)
EndIf
EndScript

Script ToggleClearMessageDisplayWindowOption ()
If (ClearDisplayWindow < 3) then
	Let ClearDisplayWindow = ClearDisplayWindow + 1
	Delay (1)
	If (ClearDisplayWindow == 1) then
		Say (msgClearWindow1, ot_status)
	ElIf (ClearDisplayWindow == 2) then
		Say (msgClearWindow2, ot_status)
	ElIf (ClearDisplayWindow == 3) then
		Say (msgClearWindow3, ot_status)
	EndIf
ElIf (ClearDisplayWindow == 3) then
	Let ClearDisplayWindow = 0
	Say (msgClearWindowOff, ot_status)
EndIf
EndScript

Script SayNextLine ()
Var String rWinTitle, String curWinClass, String curWinName, Handle curWin, Int nL, Int nR
If (!IsPCCursor ()) Then
	PerformScript SayNextLine()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
If (curWinClass == wcAte32) then
	NextLine ()
	Let nL = GetWindowLeft (curWin)
	Let nR = GetWindowRight (curWin)
;	GetItemRect (0, 0, nL, nR, 0, 0, IT_BOUNDINGRECT)
	SayTextBetween (nL, nR)
	Return
EndIf
PerformScript SayNextLine()
EndScript

Script SayPriorLine ()
Var String rWinTitle, String curWinClass, String curWinName, Handle curWin, Int nL, Int nR
If (!IsPCCursor ()) Then
	PerformScript SayPriorLine()
	Return
EndIf
Let curWin = GetCurrentWindow ()
Let curWinClass = GetWindowClass (curWin)
Let curWinName = GetWindowName (curWin)
Let rWinTitle = GetWindowName (GetRealWindow (GetFocus ()))
If (curWinClass == wcAte32) then
	PriorLine ()
	Let nL = GetWindowLeft (curWin)
	Let nR = GetWindowRight (curWin)
;	GetItemRect (0, 0, nL, nR, 0, 0, IT_BOUNDINGRECT)
	SayTextBetween (nL, nR)
	Return
EndIf
PerformScript SayPriorLine()
EndScript

Script ClearMessageDisplayWindowOnEnter ()
If (ClearDisplayWindow == 2
	&& IsMessageEditWindow () == 1) then
	{Enter}
	Let nSuppressEcho = TRUE
	ClearMessageDisplayWin ()
	ScheduleFunction ("ResetnSuppressEcho", 10)
Else
	{Enter}
EndIf
EndScript


Script HotKeyHelp ()
Var Handle rWin, Handle hSend, Handle hInfo, Handle hAdd, Handle hBlock, Handle hWarn,
	Int nSendState, Int nInfoState, Int nAddState, Int nBlockState, Int nWarnState
;	cID_SendButton = 319,
;	cID_InfoButton = 277,
;	cID_AddBuddyButton = 317,
;	cID_BlockButton = 316,
;	cID_WarnButton = 315,
;	hkmsgSendButton = "For the send button press Alt + S",
;	hkmsgInfoButton = "For the Info Button press Alt + O",
;	hkmsgAddBuddyButton = "For the Add Buddy Button press Alt + B",
;	hkmsgBlockButton = "For the Block Button press Alt + K",
;	hkmsgWarnButton = "For the Warn Button press Alt + W"
;  The buttons in the Instant Message invitation window and the instant message chat window 
; are _Oscar_IconBtn windows.  There is no text in these windows.  What appears to be text is 
; actually a part of the bitmap that appears in the center of the button.  Therefore, GetHotKey () 
; fails to return	the hot key for that control.  Thus it is necessary to hard code the hot key 
; messages for these windows.
If (IsWindowVisible (FindMessageEditWindow ()) == TRUE) then
	Let rWin = GetRealWindow (GetFocus ())
	Let hSend = FindDescendantWindow (rWin, cID_SendButton)
	Let hInfo = FindDescendantWindow (rWin, cID_InfoButton)
	Let hAdd = FindDescendantWindow (rWin, cID_AddBuddyButton)
	Let hBlock = FindDescendantWindow (rWin, cID_BlockButton)
	Let hWarn = FindDescendantWindow (rWin, cID_WarnButton)
	If (IsWindowDisabled (hSend) == TRUE) then
		Let nSendState = 0
	Else
		Let nSendState = 1
	EndIf
	If (IsWindowVisible (hInfo) == FALSE) then
		Let nInfoState = 0
	Else
		Let nInfoState = 1
	EndIf
	If (IsWindowVisible (hAdd) == FALSE) then
		Let nAddState = 0
	Else
		Let nAddState = 1
	EndIf
	If (IsWindowVisible (hBlock) == FALSE) then
		Let nBlockState = 0
	Else
		Let nBlockState = 1
	EndIf
	If (IsWindowVisible (hWarn) == FALSE) then
		Let nWarnState = 0
	Else
		Let nWarnState = 1
	EndIf
	If (nSendState) then
		Say (hkmsgSendButton, ot_help)
	EndIf
	If (nInfoState) then
		Say (hkmsgInfoButton, ot_help)
	EndIf
	If (nAddState) then
		Say (hkmsgAddBuddyButton, ot_help)
	EndIf
	If (nBlockState) then
		Say (hkmsgBlockButton, ot_help)
	EndIf
	If (nWarnState) then
		Say (hkmsgWarnButton, ot_help)
	EndIf
Else
	PerformScript HotKeyHelp()
EndIf
EndScript

Script AdjustJAWSVerbosity ()
var   	string list
if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif
let list = AutoClearWinItem +
	VerbosityLevelItem +
	ScreenEchoItem +
	TypingEchoItem  +
	SayAllByItem +
	PunctuationLevelItem +
	FormatItem +
	GraphicsItem +
	AnsiCharsIncItem +
	BrailleVerbosityItem +
	MuteSynth
	DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Script  SayWindowPromptAndText()
;SayWindowTypeAndText(GetCurrentWindow())
SayFocusedWindow ()
EndScript